DROP INDEX [IX_CBT_Tipo_Estado] ON Cbtes
GO 

CREATE NONCLUSTERED INDEX [IX_CBT_Tipo_Estado] ON [dbo].[Cbtes]
	(
		[Id_Tipo_Cbte] ASC,
		[Id_Estado_Cbte] ASC
	)
	INCLUDE([Id_Cliente],[Fecha],[Porc_Iva],[Porc_Iva2],[Imp_Gravado],[Imp_Exento],[Imp_IVA],[Imp_IVA2],[Imp_Total],
	[Id_Provincia],[Porc_Iva3],[Imp_Gravado2],[Imp_Gravado3],[Imp_NoGravado],[Imp_IVA3],[Imp_Percep],[Saldo],[Periodo_Iva],
	[Periodo],[Id_Vendedor],[Id_Moneda],[Cbte_Nro_Externo],[Id_Centro_Costo],[Nro_Auto_Trib],[Id_Estado_Proceso],[Id_Lista],[Lote]) 
GO


IF IndexProperty(Object_Id('Cbtes'), 'IX_CBT_Lista_Estado>', 'IndexID') IS NOT NULL
	DROP INDEX [IX_CBT_Lista_Estado>] ON Cbtes
GO 

IF IndexProperty(Object_Id('Cbtes'), 'IX_CBT_Lista_Estado', 'IndexID') IS NOT NULL
	DROP INDEX [IX_CBT_Lista_Estado] ON Cbtes
GO 

CREATE NONCLUSTERED INDEX [IX_CBT_Lista_Estado]
	ON [dbo].[Cbtes] ([Id_Tipo_Cbte],[Id_Lista],[Id_Estado_Cbte])
	INCLUDE ([Fecha],[Lote])
GO




IF IndexProperty(Object_Id('Cbtes'), 'IX_PorDestNroId', 'IndexID') IS NOT NULL
	DROP INDEX [IX_PorDestNroId] ON Cbtes
GO 


IF IndexProperty(Object_Id('Cbtes'), 'IX_CBT_PorDestNroId', 'IndexID') IS NULL
	CREATE NONCLUSTERED INDEX [IX_CBT_PorDestNroId] ON [dbo].[Cbtes]
	(
		[Destinatario] ASC,
		[Comprobante_Nro] ASC,
		[Id_Trans] ASC
	)
GO








